<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Job extends Model 
{

    protected $table = 'jobs';
    public $timestamps = true;
    protected $fillable = array('nature', 'tags', 'package_id');
    protected $visible = array('nature', 'tags', 'package_id');

    public function events()
    {
        return $this->belongsTo('App\Models\Event');
    }

    public function packages()
    {
        return $this->hasOne('App\Models\Package');
    }

}